/*
 * Decompiled with CFR 0.152.
 */
package link.infra.screenshotclipboard.common;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.nio.ByteBuffer;
import link.infra.screenshotclipboard.common.mixin.NativeImagePointerAccessor;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class ScreenshotToClipboard {
    public static final String MOD_ID = "screenshotclipboard";
    private static final Logger LOGGER = LogManager.getFormatterLogger((String)"ScreenshotToClipboard");

    public static void init() {
        if (!Minecraft.f_91002_) {
            try {
                Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (HeadlessException e) {
                LOGGER.warn("java.awt.headless property was not set properly!");
            }
        }
    }

    public static void handleScreenshotAWT(NativeImage img) {
        if (Minecraft.f_91002_) {
            return;
        }
        if (img.m_85102_() != NativeImage.Format.RGBA) {
            LOGGER.warn("Failed to capture screenshot: wrong format");
            return;
        }
        long imagePointer = ((NativeImagePointerAccessor)img).getPointer();
        ByteBuffer buf = MemoryUtil.memByteBufferSafe((long)imagePointer, (int)(img.m_84982_() * img.m_85084_() * 4));
        if (buf == null) {
            throw new RuntimeException("Invalid image");
        }
        ScreenshotToClipboard.handleScreenshotAWT(buf, img.m_84982_(), img.m_85084_(), 4);
    }

    public static void handleScreenshotAWT(ByteBuffer byteBuffer, int width, int height, int components) {
        byte[] array;
        if (Minecraft.f_91002_) {
            return;
        }
        if (byteBuffer.hasArray()) {
            array = byteBuffer.array();
        } else {
            array = new byte[height * width * components];
            byteBuffer.get(array);
        }
        ScreenshotToClipboard.doCopy(array, width, height, components);
    }

    private static void doCopy(byte[] imageData, int width, int height, int components) {
        new Thread(() -> {
            DataBufferByte buf = new DataBufferByte(imageData, imageData.length);
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8};
            int[] bOffs = new int[]{0, 1, 2};
            ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 3, 0);
            BufferedImage bufImg = new BufferedImage(cm, Raster.createInterleavedRaster(buf, width, height, width * components, components, bOffs, null), false, null);
            Transferable trans = ScreenshotToClipboard.getTransferableImage(bufImg);
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            c.setContents(trans, null);
        }, "Screenshot to Clipboard Copy").start();
    }

    private static Transferable getTransferableImage(final BufferedImage bufferedImage) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.imageFlavor.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (DataFlavor.imageFlavor.equals(flavor)) {
                    return bufferedImage;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }
}

